package com.hero.objects.powers;

import java.io.File;
import java.text.NumberFormat;
import java.util.Date;

import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

import com.hero.HeroDesigner;
import com.hero.objects.Adder;
import com.hero.objects.GenericObject;
import com.hero.ui.dialog.GenericDialog;
import com.hero.ui.dialog.SummonDialog;
import com.hero.util.XMLUtility;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class Summon extends Power {

	private static String xmlID = "SUMMON";

	private String filePath;

	private Date fileAssociationLastCheck;

	public Summon(Element root) {
		super(root, Summon.xmlID);
	}

	private void checkFileAssociation() {
		if (filePath == null) {
			return;
		}
		File file = new File(filePath);
		if (!file.exists()) {
			file = new File(HeroDesigner.getInstance().getPrefs().getSaveDir()
					+ File.separator + file.getName());
		}
		if (!file.exists()) {
			return;
		}

		if (file.lastModified() > fileAssociationLastCheck.getTime()) {
			setFilePath(filePath);
		}
	}

	public void clearFilePath() {
		filePath = null;
		fileAssociationLastCheck = null;
	}

	@Override
	public String getColumn2Output() {
		String ret = getAlias();
		double number = 1;
		for (Adder ad : getAssignedAdders()) {
			if (ad.getXMLID().equals("INCREASETOTAL")) {
				ad.setDisplayInString(false);
				int lvls = ad.getLevels() * ad.getLevelMultiplier();
				if (ad.getLevelPower() <= 1) {
					number = lvls;
				} else {
					number = ad.getLevelMultiplier()
							* Math.pow(ad.getLevelPower(), ad.getLevels());
				}
			}
		}
		if (number > 1) {
			ret += " " + NumberFormat.getIntegerInstance().format(number);
		}
		ret += " " + getLevels() + "-point";
		if (getName().trim().length() > 0) {
			ret = "<i>" + getName() + ":</i>  " + ret;
		}
		if ((getInput() != null) && (getInput().trim().length() > 0)) {
			ret += " " + getInput();
		} else {
			ret += " creatures";
		}
		if (getSelectedOption() != null) {
			ret += " (";
			ret += getSelectedOption().getAlias();

			String adderString = getAdderString();
			if (adderString.trim().length() > 0) {
				ret += "; " + adderString;
			}
			ret += ")";
		} else {
			String adderString = getAdderString();
			if (adderString.trim().length() > 0) {
				ret += " (" + adderString + ")";
			}
		}
		ret += getModifierString();
		if ((getEndUsage() > 0)
				&& (GenericObject.findObjectByID(HeroDesigner.getActiveHero()
						.getPowers(), "ENDURANCERESERVE") != null)
				&& (GenericObject.findObjectByID(getAllAssignedModifiers(),
						"ENDRESERVEOREND") == null)
				&& !HeroDesigner.getInstance().getPrefs().useWG()) {
			if (getUseENDReserve()) {
				ret += " (uses END Reserve)";
			} else {
				ret += " (uses Personal END)";
			}
		}
		return ret;
	}

	@Override
	public String getDamageDisplay() {
		return getLevels() + "-point " + getInput();
	}

	@Override
	public GenericDialog getDialog(boolean pIsNew, boolean pIsPower) {
		return new SummonDialog(this, pIsNew);
	}

	public String getFilePath() {
		return filePath;
	}

	@Override
	public int getLevels() {
		checkFileAssociation();
		return super.getLevels();
	}

	@Override
	public Element getSaveXML() {
		Element root = super.getSaveXML();
		if (filePath != null) {
			root.setAttribute("FILE_ASSOCIATION", filePath);
		}
		return root;
	}

	@Override
	public void restoreFromSave(Element pRoot) {
		super.restoreFromSave(pRoot);
		String check = XMLUtility.getValue(pRoot, "FILE_ASSOCIATION");
		if ((check != null) && (check.trim().length() > 0)) {
			setFilePath(check);
		}
	}

	public void setFilePath(String path) {
		File file = new File(path);
		if (!file.exists()) {
			file = new File(HeroDesigner.getInstance().getPrefs().getSaveDir()
					+ File.separator + file.getName());
		}
		if (file.exists() && file.canRead()) {
			try {
				SAXBuilder builder = new SAXBuilder(false);
				Document doc = builder.build(file);
				builder = null;
				Element root = doc.getRootElement();
				Element basic = root.getChild("BASIC_CONFIGURATION");
				String check = XMLUtility.getValue(basic, "BASE_POINTS");
				if ((check != null) && (check.trim().length() > 0)) {
					try {
						levels = Integer.parseInt(check);
					} catch (Exception exp) {
					}
				}
				if (!HeroDesigner.getActiveTemplate().is6E()) {
					check = XMLUtility.getValue(basic, "DISAD_POINTS");
					if ((check != null) && (check.trim().length() > 0)) {
						try {
							levels += Integer.parseInt(check);
						} catch (Exception exp) {
						}
					}
				}
				check = XMLUtility.getValue(basic, "EXPERIENCE");
				if ((check != null) && (check.trim().length() > 0)) {
					try {
						levels += Integer.parseInt(check);
					} catch (Exception exp) {
					}
				}
				filePath = path;
				fileAssociationLastCheck = new Date();
			} catch (Exception exp) {

			}
		}
	}
}